<?php
/**
 * Ticket System - Web Tabanlı Kurulum Scripti
 * SSH erişimi olmayan sunucular için
 * 
 * KURULUM SONRASI BU DOSYAYI SİLİN!
 */

// Güvenlik kontrolü
if (file_exists(__DIR__ . '/../.env') && file_exists(__DIR__ . '/../storage/installed.lock')) {
    die('Sistem zaten kurulmuş. Bu dosyayı silin!');
}

// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

$step = $_GET['step'] ?? 1;
$errors = [];
$success = [];

// Form gönderildi mi?
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($step == 1) {
        // .env dosyası oluştur
        $envContent = "APP_NAME=\"Ticket System\"\n";
        $envContent .= "APP_ENV=production\n";
        $envContent .= "APP_KEY=\n";
        $envContent .= "APP_DEBUG=false\n";
        $envContent .= "APP_URL=" . ($_POST['app_url'] ?? 'http://localhost') . "\n\n";
        $envContent .= "LOG_CHANNEL=stack\n";
        $envContent .= "LOG_LEVEL=error\n\n";
        $envContent .= "DB_CONNECTION=mysql\n";
        $envContent .= "DB_HOST=" . ($_POST['db_host'] ?? 'localhost') . "\n";
        $envContent .= "DB_PORT=" . ($_POST['db_port'] ?? '3306') . "\n";
        $envContent .= "DB_DATABASE=" . ($_POST['db_database'] ?? '') . "\n";
        $envContent .= "DB_USERNAME=" . ($_POST['db_username'] ?? '') . "\n";
        $envContent .= "DB_PASSWORD=" . ($_POST['db_password'] ?? '') . "\n\n";
        $envContent .= "BROADCAST_DRIVER=log\n";
        $envContent .= "CACHE_DRIVER=file\n";
        $envContent .= "FILESYSTEM_DISK=local\n";
        $envContent .= "QUEUE_CONNECTION=sync\n";
        $envContent .= "SESSION_DRIVER=file\n";
        $envContent .= "SESSION_LIFETIME=120\n\n";
        $envContent .= "MAIL_MAILER=smtp\n";
        $envContent .= "MAIL_HOST=" . ($_POST['mail_host'] ?? 'mail.yourdomain.com') . "\n";
        $envContent .= "MAIL_PORT=" . ($_POST['mail_port'] ?? '587') . "\n";
        $envContent .= "MAIL_USERNAME=" . ($_POST['mail_username'] ?? '') . "\n";
        $envContent .= "MAIL_PASSWORD=" . ($_POST['mail_password'] ?? '') . "\n";
        $envContent .= "MAIL_ENCRYPTION=tls\n";
        $envContent .= "MAIL_FROM_ADDRESS=\"" . ($_POST['mail_from'] ?? 'noreply@yourdomain.com') . "\"\n";
        $envContent .= "MAIL_FROM_NAME=\"Ticket System\"\n\n";
        $envContent .= "VITE_APP_NAME=\"Ticket System\"\n";

        if (file_put_contents(__DIR__ . '/../.env', $envContent)) {
            $step = 2;
            $success[] = '.env dosyası oluşturuldu!';
        } else {
            $errors[] = '.env dosyası oluşturulamadı. İzinleri kontrol edin.';
        }
    } elseif ($step == 2) {
        // Veritabanı bağlantısını test et
        require __DIR__ . '/../vendor/autoload.php';
        
        $app = require_once __DIR__ . '/../bootstrap/app.php';
        $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
        $kernel->bootstrap();
        
        try {
            \Illuminate\Support\Facades\DB::connection()->getPdo();
            $success[] = 'Veritabanı bağlantısı başarılı!';
            $step = 3;
        } catch (Exception $e) {
            $errors[] = 'Veritabanı bağlantı hatası: ' . $e->getMessage();
        }
    } elseif ($step == 3) {
        // Key generate ve migration
        require __DIR__ . '/../vendor/autoload.php';
        
        $app = require_once __DIR__ . '/../bootstrap/app.php';
        $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
        $kernel->bootstrap();
        
        try {
            // Key generate
            $key = 'base64:' . base64_encode(random_bytes(32));
            $env = file_get_contents(__DIR__ . '/../.env');
            $env = preg_replace('/APP_KEY=.*/', 'APP_KEY=' . $key, $env);
            file_put_contents(__DIR__ . '/../.env', $env);
            $success[] = 'APP_KEY oluşturuldu!';
            
            // Migration
            \Illuminate\Support\Facades\Artisan::call('migrate', ['--force' => true]);
            $success[] = 'Veritabanı tabloları oluşturuldu!';
            
            // Storage link
            if (!file_exists(__DIR__ . '/storage')) {
                if (function_exists('symlink')) {
                    @symlink(__DIR__ . '/../storage/app/public', __DIR__ . '/storage');
                    $success[] = 'Storage link oluşturuldu!';
                } else {
                    // Symlink desteklenmiyorsa manuel klasör oluştur
                    if (!file_exists(__DIR__ . '/storage')) {
                        mkdir(__DIR__ . '/storage', 0755, true);
                        file_put_contents(__DIR__ . '/storage/index.php', '<?php // Storage directory');
                        $success[] = 'Storage klasörü oluşturuldu (symlink desteklenmiyor)!';
                    }
                }
            }
            
            // Seeder (opsiyonel)
            if (isset($_POST['create_admin'])) {
                \Illuminate\Support\Facades\Artisan::call('db:seed', ['--force' => true]);
                $success[] = 'Varsayılan kullanıcılar oluşturuldu!';
            }
            
            // Kurulum tamamlandı işareti
            if (!file_exists(__DIR__ . '/../storage')) {
                mkdir(__DIR__ . '/../storage', 0755, true);
            }
            file_put_contents(__DIR__ . '/../storage/installed.lock', date('Y-m-d H:i:s'));
            
            $step = 4;
        } catch (Exception $e) {
            $errors[] = 'Hata: ' . $e->getMessage() . ' (Dosya: ' . $e->getFile() . ' Satır: ' . $e->getLine() . ')';
        }
    }
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket System - Kurulum</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 2rem;
        }
        h1 {
            color: #333;
            margin-bottom: 0.5rem;
        }
        .subtitle {
            color: #666;
            margin-bottom: 2rem;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 2rem;
        }
        .step {
            flex: 1;
            text-align: center;
            padding: 0.5rem;
            background: #f0f0f0;
            margin: 0 0.25rem;
            border-radius: 5px;
            font-size: 0.875rem;
        }
        .step.active {
            background: #667eea;
            color: white;
        }
        .step.completed {
            background: #10b981;
            color: white;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #333;
        }
        input, select {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
        }
        input:focus, select:focus {
            outline: none;
            border-color: #667eea;
        }
        .btn {
            background: #667eea;
            color: white;
            padding: 0.75rem 2rem;
            border: none;
            border-radius: 5px;
            font-size: 1rem;
            cursor: pointer;
            width: 100%;
            margin-top: 1rem;
        }
        .btn:hover {
            background: #5568d3;
        }
        .alert {
            padding: 1rem;
            border-radius: 5px;
            margin-bottom: 1rem;
        }
        .alert-success {
            background: #d1fae5;
            color: #065f46;
            border: 1px solid #6ee7b7;
        }
        .alert-error {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fca5a5;
        }
        .success-box {
            text-align: center;
            padding: 2rem;
        }
        .success-box h2 {
            color: #10b981;
            margin-bottom: 1rem;
        }
        .info-box {
            background: #eff6ff;
            border: 1px solid #3b82f6;
            border-radius: 5px;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        .info-box strong {
            color: #1e40af;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎫 Ticket System Kurulum</h1>
        <p class="subtitle">SSH erişimi olmayan sunucular için web tabanlı kurulum</p>
        
        <div class="step-indicator">
            <div class="step <?= $step >= 1 ? 'active' : '' ?> <?= $step > 1 ? 'completed' : '' ?>">1. Ayarlar</div>
            <div class="step <?= $step >= 2 ? 'active' : '' ?> <?= $step > 2 ? 'completed' : '' ?>">2. Test</div>
            <div class="step <?= $step >= 3 ? 'active' : '' ?> <?= $step > 3 ? 'completed' : '' ?>">3. Kurulum</div>
            <div class="step <?= $step >= 4 ? 'active' : '' ?>">4. Tamam</div>
        </div>

        <?php if (!empty($errors)): ?>
            <?php foreach ($errors as $error): ?>
                <div class="alert alert-error"><?= htmlspecialchars($error) ?></div>
            <?php endforeach; ?>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
            <?php foreach ($success as $msg): ?>
                <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
            <?php endforeach; ?>
        <?php endif; ?>

        <?php if ($step == 1): ?>
            <form method="POST">
                <div class="info-box">
                    <strong>Önemli:</strong> Önce cPanel'den MySQL veritabanı ve kullanıcı oluşturun!
                </div>

                <h3>Uygulama Ayarları</h3>
                <div class="form-group">
                    <label>Site URL</label>
                    <input type="url" name="app_url" value="<?= $_POST['app_url'] ?? 'https://yourdomain.com' ?>" required>
                </div>

                <h3>Veritabanı Ayarları</h3>
                <div class="form-group">
                    <label>MySQL Host</label>
                    <input type="text" name="db_host" value="<?= $_POST['db_host'] ?? 'localhost' ?>" required>
                    <small style="color: #666;">Genellikle: localhost</small>
                </div>
                <div class="form-group">
                    <label>MySQL Port</label>
                    <input type="text" name="db_port" value="<?= $_POST['db_port'] ?? '3306' ?>" required>
                </div>
                <div class="form-group">
                    <label>Veritabanı Adı</label>
                    <input type="text" name="db_database" value="<?= $_POST['db_database'] ?? '' ?>" required>
                    <small style="color: #666;">cPanel'den oluşturduğunuz veritabanı adı (ön ek dahil)</small>
                </div>
                <div class="form-group">
                    <label>Kullanıcı Adı</label>
                    <input type="text" name="db_username" value="<?= $_POST['db_username'] ?? '' ?>" required>
                </div>
                <div class="form-group">
                    <label>Şifre</label>
                    <input type="password" name="db_password" value="<?= $_POST['db_password'] ?? '' ?>" required>
                </div>

                <h3>Email Ayarları (Opsiyonel)</h3>
                <div class="form-group">
                    <label>SMTP Host</label>
                    <input type="text" name="mail_host" value="<?= $_POST['mail_host'] ?? 'mail.yourdomain.com' ?>">
                </div>
                <div class="form-group">
                    <label>SMTP Port</label>
                    <input type="text" name="mail_port" value="<?= $_POST['mail_port'] ?? '587' ?>">
                </div>
                <div class="form-group">
                    <label>Email Kullanıcı Adı</label>
                    <input type="text" name="mail_username" value="<?= $_POST['mail_username'] ?? '' ?>">
                </div>
                <div class="form-group">
                    <label>Email Şifre</label>
                    <input type="password" name="mail_password" value="<?= $_POST['mail_password'] ?? '' ?>">
                </div>
                <div class="form-group">
                    <label>Gönderen Email</label>
                    <input type="email" name="mail_from" value="<?= $_POST['mail_from'] ?? 'noreply@yourdomain.com' ?>">
                </div>

                <button type="submit" class="btn">Devam Et →</button>
            </form>

        <?php elseif ($step == 2): ?>
            <form method="POST">
                <input type="hidden" name="step" value="2">
                <div class="info-box">
                    <strong>Bağlantı başarılı!</strong> Şimdi kuruluma geçebiliriz.
                </div>
                <button type="submit" class="btn">Kuruluma Başla →</button>
            </form>

        <?php elseif ($step == 3): ?>
            <form method="POST">
                <input type="hidden" name="step" value="3">
                <div class="info-box">
                    <strong>Son adım!</strong> Veritabanı tabloları oluşturulacak ve sistem hazır hale gelecek.
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="create_admin" checked>
                        Varsayılan admin kullanıcısı oluştur (admin@example.com / password)
                    </label>
                </div>
                <button type="submit" class="btn">Kurulumu Tamamla →</button>
            </form>

        <?php elseif ($step == 4): ?>
            <div class="success-box">
                <h2>✅ Kurulum Tamamlandı!</h2>
                <p style="margin: 1rem 0;">Sistem başarıyla kuruldu.</p>
                
                <div class="info-box" style="text-align: left; margin-top: 2rem;">
                    <strong>ÖNEMLİ GÜVENLİK UYARISI:</strong><br>
                    Bu dosyayı (install.php) hemen silin!<br>
                    Aksi takdirde güvenlik riski oluşur.
                </div>

                <div style="margin-top: 2rem; text-align: left;">
                    <h3>Giriş Bilgileri:</h3>
                    <p><strong>Admin:</strong> admin@example.com / password</p>
                    <p><strong>Kullanıcı:</strong> user@example.com / password</p>
                    <p style="margin-top: 1rem;"><strong>Güvenlik için şifreleri değiştirin!</strong></p>
                </div>

                <div style="margin-top: 2rem;">
                    <a href="/" style="display: inline-block; background: #667eea; color: white; padding: 0.75rem 2rem; text-decoration: none; border-radius: 5px;">Ana Sayfaya Git</a>
                    <a href="/admin/dashboard" style="display: inline-block; background: #10b981; color: white; padding: 0.75rem 2rem; text-decoration: none; border-radius: 5px; margin-left: 1rem;">Admin Paneli</a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>

